<?php
/* --------------------------------------------------------------
 ApiServiceProviderRegistration.php 2020-03-10
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Api\Application\Kernel\Bootstrapper;

use Gambio\Admin\ParcelService\ParcelServiceServiceProvider;
use Gambio\Admin\TrackingCode\TrackingCodeServiceProvider;
use Gambio\Admin\Withdrawal\WithdrawalServiceProvider;
use Gambio\Api\Application\ServiceProviders\ApiErrorHandlerServiceProvider;
use Gambio\Api\Application\ServiceProviders\ApiMiddlewareServiceProvider;
use Gambio\Api\Application\ServiceProviders\RequestAuthenticationServiceServiceProvider;
use Gambio\Api\ParcelService\ParcelServiceApiServiceProvider;
use Gambio\Api\TrackingCode\TrackingCodeApiServiceProvider;
use Gambio\Api\Withdrawal\WithdrawalApiServiceProvider;
use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\AbstractBootstrapper;
use Gambio\Core\Application\ServiceProviders\Abstraction\ServiceProvider;

/**
 * Class ApiServiceProviderRegistration
 * @package Gambio\Api\Application\Kernel\Bootstrapper
 */
class ApiServiceProviderRegistration extends AbstractBootstrapper
{
    private const API_COMPONENT_SERVICE_PROVIDERS = [
        RequestAuthenticationServiceServiceProvider::class,
        ApiMiddlewareServiceProvider::class,
        ApiErrorHandlerServiceProvider::class,
    ];
    
    private const CONTROLLER_SERVICE_PROVIDERS = [
        WithdrawalApiServiceProvider::class,
        ParcelServiceApiServiceProvider::class,
        TrackingCodeApiServiceProvider::class,
    ];
    
    private const DOMAIN_SERVICE_PROVIDERS = [
        WithdrawalServiceProvider::class,
        ParcelServiceServiceProvider::class,
        TrackingCodeServiceProvider::class,
    ];
    
    
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        /** @var ServiceProvider $serviceProvider */
        foreach (self::API_COMPONENT_SERVICE_PROVIDERS as $componentServiceProvider) {
            $serviceProvider = new $componentServiceProvider($application);
            $application->addServiceProvider($serviceProvider->toLeagueInterface());
        }
        foreach (self::CONTROLLER_SERVICE_PROVIDERS as $controllerServiceProvider) {
            $serviceProvider = new $controllerServiceProvider($application);
            $application->addServiceProvider($serviceProvider->toLeagueInterface());
        }
        foreach (self::DOMAIN_SERVICE_PROVIDERS as $domainServiceProvider) {
            $serviceProvider = new $domainServiceProvider($application);
            $application->addServiceProvider($serviceProvider->toLeagueInterface());
        }
    }
}